﻿// © 2011 IDesign Inc.
// Pytania? Komentarze? Odwiedź
// http://www.idesign.net

using System;
using System.ServiceModel;
using System.ServiceModel.Description;

namespace ServiceModelEx
{
   public static class ServiceThrottleHelper
   {
      ///<summary>
      /// Metoda może być wywołana tylko przed otwarciem hosta
      ///</summary>
      public static void SetThrottle(this ServiceHost host,int maxCalls,int maxSessions,int maxInstances)
      {
         ServiceThrottlingBehavior throttle = new ServiceThrottlingBehavior();
         throttle.MaxConcurrentCalls = maxCalls;
         throttle.MaxConcurrentSessions = maxSessions;
         throttle.MaxConcurrentInstances = maxInstances;
         host.SetThrottle(throttle);
      }
      /// <summary>
      /// Metoda może być wywołana tylko przed otwarciem hosta
      /// </summary>
      /// <param name="serviceThrottle"></param>
      /// <param name="overrideConfig"></param>
      public static void SetThrottle(this ServiceHost host,ServiceThrottlingBehavior serviceThrottle,bool overrideConfig)
      {
         if(host.State == CommunicationState.Opened)
         {
            throw new InvalidOperationException("Host jest już otwarty");
         }
         ServiceThrottlingBehavior throttle = host.Description.Behaviors.Find<ServiceThrottlingBehavior>();
         if(throttle == null)
         {
            host.Description.Behaviors.Add(serviceThrottle);
            return; 
         }
         if(overrideConfig == false)
         {
            return;
         }
         host.Description.Behaviors.Remove(throttle);
         host.Description.Behaviors.Add(serviceThrottle);
      }
      /// <summary>
      /// Metoda może być wywołana tylko przed otwarciem hosta. Metoda nie nadpisuje ewentualnych wartości konfiguracyjnych.
      /// </summary>
      public static void SetThrottle(this ServiceHost host,ServiceThrottlingBehavior serviceThrottle)
      {
         host.SetThrottle(serviceThrottle,false);
      }
   }
}
